<?php

add_action('admin_menu', function () {
    add_menu_page('FraudBD', 'FraudBD', 'manage_options', 'fraud-check-settings', 'fraud_check_settings_page', 'dashicons-shield-alt', 56);
    add_submenu_page('fraud-check-settings', 'API Settings', 'Settings', 'manage_options', 'fraud-check-settings', 'fraud_check_settings_page');
    add_submenu_page('fraud-check-settings', 'Manual Check', 'Manual Search', 'manage_options', 'fraud-check-manual', 'fraud_check_manual_page');
});

function fraud_check_settings_page() {
    ?>
    <div class="wrap">
        <h1>FraudBD API Settings</h1>
        
        <div class="fraud-settings-container">
            <form method="post" action="options.php" class="fraud-settings-form">
                <?php
                settings_fields('fraud_check_options');
                do_settings_sections('fraud_check');
                submit_button('Save Settings', 'primary', 'submit', true, array('id' => 'fraud-save-settings'));
                ?>
            </form>
            
            <div class="fraud-settings-sidebar">
                <div class="fraud-settings-card">
                    <h3><span class="dashicons dashicons-info"></span> API Information</h3>
                    <p>Enter your FraudBD API credentials to enable fraud checking functionality.</p>
                    <p>If you don't have credentials, please contact FraudBD support.</p>
                    <p>Check Your API Key and Username carefully. Check your account <a href="https://fraudbd.com/dashboard/settings" target="_blank">here</a>.</p>
                </div>
                
                <div class="fraud-settings-card">
                    <h3><span class="dashicons dashicons-admin-tools"></span> Connection Test</h3>
                    <button id="test-connection-btn" class="button button-secondary">Test API Connection</button>
                    <div id="connection-test-result" style="margin-top:10px;"></div>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .fraud-settings-container {
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }
        
        .fraud-settings-form {
            flex: 1;
            background: #fff;
            padding: 20px;
            border: 1px solid #ccd0d4;
            box-shadow: 0 1px 1px rgba(0,0,0,0.04);
            border-radius: 3px;
        }
        
        .fraud-settings-sidebar {
            width: 300px;
        }
        
        .fraud-settings-card {
            background: #fff;
            border: 1px solid #ccd0d4;
            box-shadow: 0 1px 1px rgba(0,0,0,0.04);
            border-radius: 3px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .fraud-settings-card h3 {
            margin-top: 0;
            font-size: 14px;
            display: flex;
            align-items: center;
        }
        
        .fraud-settings-card h3 .dashicons {
            margin-right: 8px;
            color: #2271b1;
        }
        
        .form-table th {
            width: 200px;
        }
        
        #fraud-save-settings {
            margin-top: 15px;
        }
        
        #test-connection-btn {
            margin-top: 5px;
        }
        
        .notice {
            padding: 12px;
            margin: 0;
            border-left: 4px solid;
        }
        
        .notice-success {
            background: #f0f9eb;
            border-left-color: #67c23a;
        }
        
        .notice-error {
            background: #fef0f0;
            border-left-color: #f56c6c;
        }
    </style>
    
    <script>
        jQuery(document).ready(function($) {
            $('#test-connection-btn').click(function() {
                var $btn = $(this);
                var $result = $('#connection-test-result');
                
                $btn.prop('disabled', true).text('Testing...');
                $result.html('<span class="spinner is-active" style="float:none;"></span> Testing connection...');
                
                $.ajax({
                    url: 'https://fraudbd.com/api/check-api-connection',
                    method: 'POST',
                    headers: {
                        'api_key': $('input[name="fraud_check_api_key"]').val(),
                        'user_name': $('input[name="fraud_check_username"]').val(),
                        'password': $('input[name="fraud_check_password"]').val(),
                        'Content-Type': 'application/json'
                    },
                    success: function (res) {
                        if (res.status) {
                            $result.html('<div class="notice notice-success"><p>' + res.message + '</p></div>');  
                        } else {
                            $result.html('<div class="notice notice-error"><p>' + res.message + '</p></div>');
                        }
                    },
                    error: function (xhr, status, error) {
                        var errorMessage = xhr.status + ': ' + xhr.statusText;
                        $result.html('<div class="notice notice-error"><p>Connection failed: ' + errorMessage + '</p></div>');
                    },
                    complete: function () {
                        $btn.prop('disabled', false).text('Test API Connection');
                    }
                });
            });
        });
    </script>
    <?php
}

add_action('admin_init', function () {
    register_setting('fraud_check_options', 'fraud_check_api_key', [
        'sanitize_callback' => 'sanitize_text_field',
        'show_in_rest' => false
    ]);
    
    register_setting('fraud_check_options', 'fraud_check_username', [
        'sanitize_callback' => 'sanitize_text_field',
        'show_in_rest' => false
    ]);
    
    register_setting('fraud_check_options', 'fraud_check_password', [
        'sanitize_callback' => 'sanitize_text_field',
        'show_in_rest' => false
    ]);

    add_settings_section(
        'fraud_check_section', 
        'API Credentials', 
        function() {
            echo '<p>Enter your FraudBD API credentials below. Keep these secure.</p>';
        }, 
        'fraud_check'
    );

    add_settings_field(
        'fraud_check_api_key', 
        'API Key', 
        function () {
            echo '<input type="text" name="fraud_check_api_key" value="' . esc_attr(get_option('fraud_check_api_key')) . '" class="regular-text" autocomplete="off" />';
            echo '<p class="description">Your unique API key provided by FraudBD</p>';
        }, 
        'fraud_check', 
        'fraud_check_section'
    );

    add_settings_field(
        'fraud_check_username', 
        'Username', 
        function () {
            echo '<input type="text" name="fraud_check_username" value="' . esc_attr(get_option('fraud_check_username')) . '" class="regular-text" autocomplete="off" />';
            echo '<p class="description">Your FraudBD account username</p>';
        }, 
        'fraud_check', 
        'fraud_check_section'
    );

    add_settings_field(
        'fraud_check_password', 
        'Password', 
        function () {
            echo '<input type="password" name="fraud_check_password" value="' . esc_attr(get_option('fraud_check_password')) . '" class="regular-text" autocomplete="off" />';
            echo '<p class="description">Your FraudBD account password</p>';
        }, 
        'fraud_check', 
        'fraud_check_section'
    );

    add_settings_field(
        'fraud_check_link', 
        'API Information', 
        function () {
            echo '<p>Check your account <a href="https://fraudbd.com/dashboard/settings" target="_blank">here</a>.</p>';
        }, 
        'fraud_check', 
        'fraud_check_section'
    );
});
